<?php
session_start();
include 'config.php';

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

// Fetch products
$result = $conn->query("SELECT * FROM product ORDER BY created_at DESC");

// Count cart items
$cart_count = isset($_SESSION['cart']) ? count($_SESSION['cart']) : 0;
?>

<!DOCTYPE html>
<html>
<head>
<title>User Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { padding-top: 70px; background-color: #ffe6f0; }
.navbar .cart-badge { background: red; color: white; border-radius: 50%; padding: 2px 6px; font-size: 12px; margin-left: 5px; }
.product-card img { height: 200px; object-fit: cover; transition: transform 0.3s; }
.product-card img:hover { transform: scale(1.05); }
.btn-cart { background: #ff4e50; color: white; font-weight: bold; border: none; width: 100%; margin-top: 10px; }
.btn-cart:hover { background: #f9d423; color: #222; }
.toast { position: fixed; top: 20px; right: 20px; z-index: 9999; }
</style>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php">🎨 Art Shop</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto align-items-center">
        <li class="nav-item"><a class="nav-link" href="dashboard.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="my_orders.php">My Orders</a></li>
        <li class="nav-item">
          <a class="nav-link" href="checkout.php">
            🛒 Cart
            <span id="cart-count" class="cart-badge"><?= $cart_count ?></span>
          </a>
        </li>
        <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<!-- Products -->
<div class="container py-5">
<h2 class="mb-4 text-center">🖼️ Products Gallery</h2>
<div class="row">
<?php while($row = $result->fetch_assoc()): ?>
<div class="col-md-4 mb-4">
<div class="card product-card shadow-sm">
<img src="data:image/jpeg;base64,<?= base64_encode($row['image']) ?>" class="card-img-top" alt="<?= htmlspecialchars($row['name']) ?>">
<div class="card-body text-center">
<h5 class="card-title"><?= htmlspecialchars($row['name']) ?></h5>
<p class="card-text"><?= htmlspecialchars($row['description']) ?></p>
<p class="fw-bold">₹<?= number_format($row['price'],2) ?></p>
<button class="btn btn-cart add-to-cart" 
    data-id="<?= $row['id'] ?>" 
    data-name="<?= htmlspecialchars($row['name']) ?>" 
    data-price="<?= $row['price'] ?>" 
    data-image="<?= base64_encode($row['image']) ?>">
    🛒 Add to Cart
</button>
</div>
</div>
</div>
<?php endwhile; ?>
</div>
</div>

<!-- Toast notification -->
<div id="toast" class="toast bg-success text-white p-2" style="display:none;">Added to cart!</div>

<script>
$(document).ready(function(){
    $('.add-to-cart').click(function(){
        let button = $(this);
        $.post('add_to_cart_ajax.php', {
            product_id: button.data('id'),
            name: button.data('name'),
            price: button.data('price'),
            image: button.data('image')
        }, function(response){
            // Show toast notification
            $('#toast').fadeIn(400).delay(1000).fadeOut(400);
            // Update cart count in navbar
            $('#cart-count').text(response.cart_count);
        }, 'json');
    });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
