<?php
session_start();
include 'config.php';

$msg = "";

if(isset($_POST['login'])){
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Fetch user by email
    $stmt = $conn->prepare("SELECT id, username, email, password, role FROM users WHERE email=?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if($stmt->num_rows == 1){
        $stmt->bind_result($id, $db_username, $db_email, $db_password, $role);
        $stmt->fetch();

        // Compare password directly (plain text)
        if($password === $db_password){
            $_SESSION['user_id'] = $id;
            $_SESSION['username'] = $db_username;
            $_SESSION['role'] = $role;

            // Redirect based on role
            if($role == 'admin'){
                header("Location: admin/index.php");
            } else {
                header("Location: dashboard.php");
            }
            exit;
        } else {
            $msg = "Incorrect email or password!";
        }
    } else {
        $msg = "Incorrect email or password!";
    }
    $stmt->close();
}
?>

<!-- Login Form -->
<!DOCTYPE html>
<html>
<head>
    <title>User Login</title>
    <style>
        /* Body styling */
        body {
             font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
             background: pink;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        /* Form container */
        .login-container {
            background-color: #ffffff;
            padding: 40px 30px;
            border-radius: 15px;
            box-shadow: 0px 10px 25px rgba(0, 0, 0, 0.2);
            width: 350px;
            text-align: center;
        }

        /* Heading */
        h2 {
            color: #333;
            margin-bottom: 25px;
        }

        /* Input fields */
        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            border-radius: 8px;
            border: 1px solid black;
            box-sizing: border-box;
            transition: 0.3s;
            font-size:15px;
        }

       
        /* Button */
        button {
            width: 100%;
            padding: 12px;
            margin-top: 15px;
            background-color:  #d21dd8ff;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: 0.3s;
        }

        button:hover {
            background-color: #d21dd8ff;
        }

        /* Message styling */
        .msg {
            margin-top: 15px;
            padding: 10px;
            border-radius: 8px;
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }

        p {
        margin-top: 20px;
        font-size: 14px;
    }

    p a {
        color: #d21dd8ff;
        text-decoration: none;
        font-size:16px;
    }

    p a:hover {
        text-decoration: underline;
    }
    </style>
</head>
<body>
   <div class="login-container">
    <h2>User Login</h2>
    <?php if($msg != ""): ?>
        <div class="msg"><?php echo $msg; ?></div>
    <?php endif; ?>
    <form method="POST">
        <input type="email" name="email" placeholder="Email" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit" name="login">Login</button>
    </form>
    <p>Don't have an account? <a href="register.php">Register Here</a></p>
      <a href="index.php">Back to Dashboard</a>
</div>
</body>
</html>